// Exp-13 : Design Low Pass Filter as per the given specification and plot the Frequency Response.

// Version : Scilab 5.4.1
// Operating Syatem : Window-xp, Window-7

clc;
close;
clear;
delta1=0.1;    // Atennuation
delta2=0.1;
fl=400;        // Low Cut-Off Frequency
fh=500;        // High Cut-Off Frequency
fs=8000;       // Sampling Frequency
A=-20*log10(min(delta1:delta2));
w1=2*%pi*fl/fs;
w2=2*%pi*fh/fs;
temp=1+((A-8)/(2.285*((2*3.14*fh/fs)-(2*3.14*fl/fs))));
N=ceil((temp-1)/2);
n=-N:N;
h=(((w2+w1)/2)*(sinc(((w2+w1)/2)*n)))/(3.14);  // Response
//plot(n,h);

[xm1,fr1]=frmag(h,8000);          // Frequency Response
figure;
plot(fr1,xm1);
title('Frequency Response','color','red','fontsize', 4);
xlabel("Frequency (Normalized)", "fontsize", 2,"color", "blue");
ylabel("Magnitude", "fontsize", 2, "color", "blue");



